$(function() {
	
    function xml_parser(wrapper) {
    
	//Construct and display preloader
     //$('<div id="preload_xml"></div>').html('<img src="http://software.intel.com/file/25845" alt="loading data" /><h3>Loading Data...</h3>').prependTo($('body'));
     	
     	//Hide Wrapper Content 
        $(wrapper).hide();
		
		//Hide all the 'lightbox' areas
		$('#boxes .window').hide(); 
		
		
		//Randomly display the right-side banners on load
		var bannerImageTotal = 4;
        var bannerImageNameNumber= new Array("25831","25832","25833","25834");
        randomNumber = Math.round(Math.random()*(bannerImageTotal-1));      
        var imgPath = ('http://software.intel.com/file/' + bannerImageNameNumber[randomNumber]);
        $('#banner img').attr('src', imgPath);

		
		//Get XML Data
        $.ajax({
            type: 'GET',
            url: 'http://software.intel.com/sites/products/learninglab/learninglab1.xml',
            dataType: 'xml',
            success: function(xml_list) {
            
			  //Remove preloader HTML & show data
       		  $('#preload_xml').remove();
       		  $(wrapper).show();
			  
				//Iterate through the XML
                $(xml_list).find('item').each(function(i) {
					
					//Meta Data
                    var xml_uploadDate  = $(this).attr('uploadDate'); 
					var xml_mediaFormat = $(this).attr('mediaFormat');
					var xml_authorName  = $(this).attr('authorName');
					var xml_assetType   = $(this).attr('assetType');
					var xml_OS			= $(this).attr('operatingSystem');
					var item_id			= $(this).attr('id');
					var externalID		= '#' + item_id;
					
					//Description
					var xml_topic       = "";
					var all_xml_topics  = "";
					var all_xml_skills  = "";
					var media_url		= "";
					var externalBox		= "";
					var testThis		= "";
					var xml_skillLevel 	= "";
					var xml_description = $(this).find('description').text();
					var xml_productName = $(this).find('productName').text();
					var xml_title       = $(this).find('title').text();
					var file_url		= $(this).find('mediaFilePath').text();
					
					//Limit shown topic by 1, but also set all topics  (available in span on hover)
					$(this).find("devTopic").each(function(i) {
					  	
						all_xml_topics += $(this).text() + " / ";
							
						if ( i == 0 ) {
							
							return xml_topic += $(this).text() + " ";
						}
						
					});
					
					//Limit shown skill set by 1, but also set 'ALL' 
					
					$(this).find("skillLevel").each(function(i) {
					  	
						all_xml_skills += $(this).text() + " / ";
							
						if ( i == 0 ) {
							
							return xml_skillLevel += $(this).text() + " ";
						}
						
	
					});
					
					//Swap in media images, on click call 'lightbox' functionality
					
					if(xml_mediaFormat == "Video") {
						media_url = '<a class="videoLink mediaLink" href="#' + item_id + '" name="modal"><img src="http://software.intel.com/file/25869" width="50" height="38" alt="Video file" /></a>';
						externalBox = "modal";
						//alert(media_url);
					}
					else if(xml_mediaFormat == "PDF") {
						media_url = '<a class="pdfLink" href="' + file_url + '" target="_blank"><img src="http://software.intel.com/file/25865" width="50" height="38" alt="PDF file" /></a>';
						//media_url = '<a class="pdfLink" target="_blank" onclick="alert(\'yo\')"><img src="http://software.intel.com/file/25865" width="50" height="38" alt="PDF file" />file_url = ' + file_url + '</a>';				

						externalID = file_url;
						externalBox = "normal";
					}
					else if(xml_mediaFormat == "URL") {
						media_url = '<a class="pdfLink" href="' + file_url + '" target="_blank"><img src="http://software.intel.com/file/26078" width="50" height="38" alt="URL Link" /></a>';
						//media_url = '<a class="pdfLink" target="_blank" onclick="alert(\'yo\')"><img src="images/home/icons/pdfIcon.jpg" width="50" height="38" alt="PDF file" />file_url = ' + file_url + '</a>';				

						externalID = file_url;
						externalBox = "normal";
					}

					else if(xml_mediaFormat == "Audio") {
						media_url = '<a class="audioLink mediaLink" href="#' + item_id + '" name="modal"><img src="http://software.intel.com/file/25859" width="50" height="38" alt="Audio file" /></a>';
						externalBox = "modal";
						//alert(media_url);
					}
					
					
					//Dynamically loading the 'lightbox' content
					$('<div id="' + item_id + '" class="window">' + file_url + '<a href="#" class="close">CLOSE</a></div>').appendTo('#dynamicDialogs');
			
                    // append data / HTML to source table 
					 $('<tr filterCriteria="'+ all_xml_skills +  xml_OS + all_xml_topics +  xml_productName + '"></tr>').html('<td>'+ '<a class="showMoreTitle" href="' + externalID + '" name="' + externalBox + '" id="showMoreTitle' +  i + '" target="_blank">' + xml_title + '</a>' + " " + ' by' + " " + xml_authorName + " " + "&mdash;" + " " + '<strong>' + xml_assetType + '</strong>' + '</td><td class="zebra"><span class="changeTopic">'+ xml_topic + '</span>' + '<a class="showMore" href="#" id="showMore' + i + '"><strong>More &rsaquo; </strong></a>' +'</td><td>'+ '<span class="skill">' + xml_skillLevel.substr(0, 3) + '.' + '</span>' + '</td><td class="zebra">'+ xml_productName +'</td><td>'+ media_url +'</td><td class="zebra">'+ xml_uploadDate  +'</td>').appendTo(wrapper +' table tbody');
					 
					 // add tooltips to title and more
					$("#showMoreTitle"+i).easyTooltip({
						content: xml_description,
						xOffset: -20,
						yOffset: -10
					}); 
					$("#showMore"+i).easyTooltip({
						content: all_xml_topics,
						xOffset: -20,
						yOffset: -10
					});

                }); // end each loop
				
				//Lightbox specific functionality is controlled below
				
				 var cssObj = {
					  'position' : 'absolute',
					  'display' : 'none',
					  'z-index' : '9999',
					  'padding' : '20px'
				}
				$('#boxes .window').css(cssObj);
				
				$('a[name=modal]').click(function(e) {
				/*$('.mediaLink').click( function(e) {*/
					//Cancel the link behavior
					e.preventDefault();
				
					//Get the A tag
					var boxID = $(this).attr('href');

					$('#boxes .window').height = $(boxID).height();
					$('#boxes .window').width = $(boxID).width();
					
					//Get the screen height and width
					var maskHeight = $(document).height();
					var maskWidth = $(window).width();
				
					//Set height and width to mask to fill up the whole screen
					$('#mask').css({'width':maskWidth,'height':maskHeight});
					
					//transition effect
					$('#mask').fadeTo(1,0.8);
					$('#mask').fadeIn(700);	
					//$('#mask').fadeTo("slow",0.8);	
					
					var winH = $(window).height();
					var winW = $(window).width();
					
					$(boxID).css('top',  winH/2-$(boxID).height()/2);
					$(boxID).css('left', winW/2-$(boxID).width()/2);
				
					$(window).resize(function() {
											  
						maskHeight = $(document).height();
						maskWidth = $(window).width();
						
						$('#mask').css({'width':maskWidth,'height':maskHeight});
  						
						winH = $(window).height();
						winW = $(window).width();
						//alert("Height is : " + winH);
						//alert("Width is : " + winW);
							  
						//Set the popup window to center
						$(boxID).css('top',  winH/2-$(boxID).height()/2);
						$(boxID).css('left', winW/2-$(boxID).width()/2);
					});
		
					$(boxID).fadeIn(2000); 
				
				});
				
				//if close button is clicked
				$('.window .close').click(function (e) {
					//Cancel the link behavior
					e.preventDefault();
					$('#mask, .window').hide();
				});		
				
				//if mask is clicked
				$('#mask').click(function () {
					$(this).hide();
					$('.window').hide();
				});			
				
				//End lightbox functionality
				
				
				
				//Cleaning up some miscellaneous features below
				//alert($('#tableContents').html());
				$($('#tableContents').children('table')[0]).append('<p id="noResults">There are no results that match your criteria.</p>')
				//$('<p id="noResults">There are no results that match your criteria.</p>').appendTo('#tableContents');
				
				
				$("td").find(":contains('ALL.')").text('ALL');
				
				$(".showMore").find(":contains('/')").each(function(i) {
							
					if($(this).text().length < 30) {
						$(this).parent().hide();
					}	
					
				});
				
						
				 //Add sort to table 
				//$(wrapper +' table').tablesorter({sortList:[[5,1],[5,1]]});  // 5 is set to 'Upload Date', 1 is set to the most recent date
				$(wrapper +' table').tablesorter({sortList:[[5,1]]});
				$(wrapper +' table').hide().slideDown('200');
						
				//Filter results functionality!
	
				//Capturing the original results, first set by all the xml fun up above
				var test_topic = "";
				var topicsArray = [];
					
				$(".changeTopic").each( function() {
						
					test_topic = $(this).text();
					//console.log( test_topic );
					topicsArray.push(test_topic);
						
				});
				
				//When the select boxes change
				
				$(".chooseSelection").change(function () {
																							
				 	var name = $(this).attr("id");
				 	var list = this;
					var id = "#" + name;
					var className = "." + name;
					var str = new Array();
						
					$("tr", "#results").show();
	
					//Reverting all the info back to its original state
					if($(this).val() == 1) {
						$("tr", "#results").show();

							
						$.each(topicsArray, function(index, value) {
					
							$(".changeTopic").show();
							
							$(".changeTopic").eq(index).html(value);
						
						});
			
					}
					
					//Reverting all the info back to its original state
					$("#resetBtn").click(function() {
												  			
						$('.chooseSelection').val(1);
						
						$("tr", "#results").show();
						
						$('#noResults').css("color", "white");
							
						$.each(topicsArray, function(index, value) {
						
							$(".changeTopic").show();
								
							$(".changeTopic").eq(index).html(value);
							
						});
							
					})
					
					//Automatically swapping out the search result html based on what's selected
				
					if($("#topicList option:selected").val() > 1) {
								
						$(".changeTopic").html($("#topicList option:selected").text());
							
					}

					//Main functionality behind the filtering
					$(".chooseSelection option:selected").each(function () {	
						
						var selected = $(this).text();	

			
						if($(this).val() > 1) {
		
							$("tr", "#results").filter(function (index) {
					
									//alert($(this).attr("filtercriteria"));
								var result = $(this).attr("filtercriteria");
									
								if(result.indexOf(selected) > -1) {
									
									return false;
								}
								else {
									
									return true;
								}									
							}).hide();

						}
						
					   //If there are no results, show the paragraph message
					   var trsShown = $('tr:has(:visible)').length; 
					   if(trsShown == 1) {
							//alert('black');
							$('#tableContents').find("p[id=noResults]").css("color", "black");
					   }
					   else {
						   //alert('white');
						   $('#tableContents').find("p[id=noResults]").css("color", "white");   
					   }
							
					});
						
				});
		 						  
			} // end post AJAX call operaitons
        }); // end AJAX
    } 
	// end function
  
 	//Function Call
 	var wrapper = '#xml_wrapper'; // Id of wrapper
 	xml_parser(wrapper);
 	
 	//var nav_link = $('thead th'); //Navigation <LI> Link for filtering event
	
});

